// Array.cpp: implementation of the CArray class.
//
//////////////////////////////////////////////////////////////////////

#include "pch.h"
#include "Array.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CArray::CArray(UINT nCapacity)
{
	if (nCapacity == 0)
		m_byteArray = NULL;
	else
		m_byteArray = new BYTE[nCapacity];
	m_nCapacity = nCapacity;
}

CArray::~CArray()
{
	if (m_nCapacity > 0)
		delete [] m_byteArray;
}

void CArray::RequestCapacity(UINT nCapacity) {
	if (m_nCapacity < nCapacity) {
		if (m_nCapacity > 0)
			delete [] m_byteArray;
		m_nCapacity <<= 2;
		if (m_nCapacity < nCapacity)
			m_nCapacity = nCapacity;
		if (m_nCapacity == 0)
			m_byteArray = NULL;
		else
			m_byteArray = new BYTE[m_nCapacity];
	}
}
